﻿import arcpy
from arcpy import env
import os
import math
import datetime
params=[]
type_reseau='Eaux pluviales'

class Toolbox(object):
	def __init__(self):
		"""Define the toolbox (the name of the toolbox is the name of the
		.pyt file)."""
		self.label = "Toolbox"
		self.alias = ""

		# List of tool classes associated with this toolbox
		self.tools = [Tool]


class Tool(object):
	def __init__(self):
		"""Define the tool (tool name is the name of the class)."""
		self.label = "TT-Export_to_SWMM"
		self.description = u"édite les données des éléments du reseau d'assainissement dans un fichier permettant leur import dans SWMM"
		self.canRunInBackground = False

	def getParameterInfo(self):
		"""Define parameter definitions"""
		global params
		#polygone de selection
		polygSelection = arcpy.Parameter(
		displayName="Polygone servant pour la selection",
		name="in_poly",
		datatype=["GPFeatureLayer","DEFeatureClass"],
		parameterType="Required",
		direction="Input")
		
		#choix type de reseau 
		reseau = arcpy.Parameter(
		displayName='type de reseau pour l\'analyse'
		, name='Type_reseau'
		, datatype='GPString'
		, parameterType='Required'
		, direction='Input')
		
		reseau.filter.type = "ValueList"
		reseau.filter.list = ['Eaux pluviales et Eaux mélangées','Eaux usées et Eaux mélangées']
		reseau.value = 'Eaux pluviales et Eaux mélangées'
		
		#choix TAUX_IMPERM_ACTUEL ou TAUX_IMPERM_SATURATION
		taux_imperm = arcpy.Parameter(
		displayName='TAUX_IMPERM_ACTUEL ou TAUX_IMPERM_SATURATION'
		, name='taux_imperm'
		, datatype='GPString'
		, parameterType='Required'
		, direction='Input')
		
		taux_imperm.filter.type = "ValueList"
		taux_imperm.filter.list = ['TAUX_IMPERM_ACTUEL','TAUX_IMPERM_SATURATION']
		taux_imperm.value = 'TAUX_IMPERM_ACTUEL'
	
		#choix couche ou classe d'entité subcatchment: RAE_SOUS_BASSIN_VERSANT
		subcatchment = arcpy.Parameter(
		displayName="Classe d\'entite contenant les sous bassins versants",
		name="in_subcatchment",
		datatype=["GPFeatureLayer","DEFeatureClass"],
		parameterType="Required",
		direction="Input")
		#arcpy.env.workspace =r'C:\Users\ypottier\AppData\Roaming\ESRI\Desktop10.2\ArcCatalog\Connexion à vs11.sde'#a modifier lors de l'installation
		fc='RAE_SOUS_BASSIN_VERSANT'
		subcatchment.value =fc
		
		#choix couche ou classe d'entités junctions: RAE_REGARD_CHAMBRE
		junctions = arcpy.Parameter(
		displayName="Classe d\'entités contenant les regards/chambres",
		name="in_junctions",
		datatype=["GPFeatureLayer","DEFeatureClass"],
		parameterType="Required",
		direction="Input")
		#arcpy.env.workspace =r'C:\Users\ypottier\AppData\Roaming\ESRI\Desktop10.2\ArcCatalog\Connexion à vs11.sde'#a modifier lors de l'installation
		fc2='RAE_REGARD_CHAMBRE'
		junctions.value =fc2
		
		#choix couche ou classe d'entités rejet: RAE_PT_REJET
		outfalls = arcpy.Parameter(
		displayName="Classe d\'entités contenant les outfalls/points de rejet",
		name="in_outfalls",
		datatype=["GPFeatureLayer","DEFeatureClass"],
		parameterType="Required",
		direction="Input")
		#arcpy.env.workspace =r'C:\Users\ypottier\AppData\Roaming\ESRI\Desktop10.2\ArcCatalog\Connexion à vs11.sde'#a modifier lors de l'installation
		fc3='RAE_PT_REJET'
		outfalls.value =fc3
		
		#choix couche ou classe d'entités deversoires: RAE_DEVERSOIR
		deversoire = arcpy.Parameter(
		displayName="Classe d\'entités contenant les déversoirs",
		name="in_deversoire",
		datatype=["GPFeatureLayer","DEFeatureClass"],
		parameterType="Required",
		direction="Input")
		#arcpy.env.workspace =r'C:\Users\ypottier\AppData\Roaming\ESRI\Desktop10.2\ArcCatalog\Connexion à vs11.sde'#a modifier lors de l'installation
		fc4='RAE_DEVERSOIR'
		deversoire.value =fc4
		
		#choix couche ou classe d'entités storage: RAE_STOCKAGE_EAUX
		storage = arcpy.Parameter(
		displayName="Classe d\'entités contenant les stockages",
		name="in_storage",
		datatype=["GPFeatureLayer","DEFeatureClass"],
		parameterType="Required",
		direction="Input")
		#arcpy.env.workspace =r'C:\Users\ypottier\AppData\Roaming\ESRI\Desktop10.2\ArcCatalog\Connexion à vs11.sde'#a modifier lors de l'installation
		fc5='RAE_STOCKAGE_EAUX'
		storage.value =fc5
		
		#choix couche ou classe d'entités collecteurs:RAE_COLLECTEUR
		collecteurs = arcpy.Parameter(
		displayName="Classe d\'entités contenant les collecteurs",
		name="in_collector",
		datatype=["GPFeatureLayer","DEFeatureClass"],
		parameterType="Required",
		direction="Input")
		#arcpy.env.workspace =r'C:\Users\ypottier\AppData\Roaming\ESRI\Desktop10.2\ArcCatalog\Connexion à vs11.sde'
		fc6='RAE_COLLECTEUR'
		collecteurs.value =fc6
		
		# output
		outparam = arcpy.Parameter(
			displayName="Choix du fichier d\'import dans SWMM",
			name="out_features",
			datatype="GPType",
			parameterType="Required",
			direction="Output")
		outparam.value='D:\Develop\9401.1-Geneve-GDEau-SWMM\Source\importSWMM2.inp'#\\sitgsrv01\si-eau\09 - Scripts\00-CRAE-SWMM\Fichiers_INP\importSWMM2.inp'#
		
		#START_DATE	
		start_date = arcpy.Parameter(
		displayName="start date",
		name="start_date",
		datatype="GPDate",
		parameterType="Required",
		direction="Input")
		start_date.value='1988-06-23	17:20:00'
		#REPORT_START_DATE
		report_start_date = arcpy.Parameter(
		displayName="report start date",
		name="report_start_date",
		datatype="GPDate",
		parameterType="Required",
		direction="Input")
		report_start_date.value='1988-06-23	17:20:00'
		#END_DATE
		end_date = arcpy.Parameter(
		displayName="end date",
		name="end_date",
		datatype="GPDate",
		parameterType="Required",
		direction="Input")
		end_date.value='1988-06-25	00:00:00'
		return [polygSelection,reseau,taux_imperm,subcatchment,junctions,outfalls,deversoire,storage,collecteurs,outparam,start_date,report_start_date,end_date]

	def isLicensed(self):
		"""Set whether tool is licensed to execute."""
		return True

	def updateParameters(self, parameters):
		"""Modify the values and properties of parameters before internal
		validation is performed.  This method is called whenever a parameter
		has been changed."""
		return

	def updateMessages(self, parameters):
		"""Modify the messages created by internal validation for each tool
		parameter.  This method is called after internal validation."""
		return
		
	def execute(self, parameters, messages):
		"""The source code of the tool."""
		global type_reseau
		listBVsansObjAmont=[]
		listRegardsansAltitude=[]
		listConduitsansObjAmont=[]
		listConduitsansObjAval=[]
		autres_erreurs=''
		###création du fichier d'import dans SWMM
		fichier_export=parameters[9].valueAsText
		self.fichier=open(fichier_export,"w")
		arcpy.AddMessage('le fichier créé sera: '+str(fichier_export))
		##création flichier log
		d=datetime.datetime.now()
		dateheure='_'+str(d.day)+'_'+str(d.month)+'_'+str(d.year)+'_'+str(d.hour)+'h'+str(d.minute)
		DirNamelog=os.path.dirname(fichier_export)#\\sitgsrv01\si-eau\09 - Scripts\00-CRAE-SWMM\Fichiers_INP\importSWMM2.inp'
		bname=str(os.path.basename(fichier_export))
		FichierLog=DirNamelog+'\\log_'+str(bname[:-4])+dateheure+'.log'
		self.fichierLog=open(FichierLog,"w")
		arcpy.AddMessage('le fichier log créé sera: '+str(FichierLog))
		
		self.fichierLog.write(str(d.day)+'/'+str(d.month)+'/'+str(d.year)+' '+str(d.hour)+'h'+str(d.minute)+'\n')
		try:
			###nom polygone servant a la seclection
			polygSelect=parameters[0].valueAsText
			###type de reseaux pluviales ou usées
			contenu_analyse=parameters[1].valueAsText
			if contenu_analyse.encode('utf-8')=='Eaux pluviales et Eaux mélangées':
				type_reseau='Eaux pluviales'
				self.fichierLog.write('Analyse eaux pluviales\n')
			elif contenu_analyse.encode('utf-8')=='Eaux usées et Eaux mélangées':
				type_reseau='Eaux usées'
				self.fichierLog.write('Analyse eaux usées\n')
			else:
				type_reseau='Eaux mélangées'
				self.fichierLog.write('Analyse eaux mélangées\n')
			
			#titre
			self.fichier.write('[TITLE]\nSWMM_export\n')
			#options
			d=parameters[10].valueAsText
			sd=parameters[10].value.date()
			start_date=str(sd.month)+'/'+str(sd.day)+'/'+str(sd.year)
			start_time=parameters[10].value.time()
			rsd=parameters[11].value.date()
			report_start_date=str(rsd.month)+'/'+str(rsd.day)+'/'+str(rsd.year)
			report_start_time=parameters[11].value.time()
			ed=parameters[12].value.date()
			end_date=str(ed.month)+'/'+str(ed.day)+'/'+str(ed.year)
			end_time=parameters[12].value.time()
			
			self.fichier.write('\n[OPTIONS]\n')
			self.fichier.write('FLOW_UNITS	LPS\nINFILTRATION	HORTON\nFLOW_ROUTING	DYNWAVE\nLINK_OFFSETS 	DEPTH\nMIN_SLOPE	0\nALLOW_PONDING	NO\nSKIP_STEADY_STATE	NO\nSTART_DATE	'+str(start_date)+'\nSTART_TIME '+str(start_time)+'\n')
			self.fichier.write('REPORT_START_DATE	'+str(report_start_date)+'\nREPORT_START_TIME	'+str(report_start_time)+'\nEND_DATE	'+str(end_date)+'\nEND_TIME '+str(end_time)+'\nSWEEP_START	01/01\nSWEEP_END	01/31\nDRY_DAYS	0\nREPORT_STEP	00:01:00\n')
			self.fichier.write('WET_STEP	00:01:00\nDRY_STEP	00:01:00\nROUTING_STEP	00:00:10\nINERTIAL_DAMPING	PARTIAL\nNORMAL_FLOW_LIMITED	BOTH\nFORCE_MAIN_EQUATION	H-W\nVARIABLE_STEP	0.75\nLENGTHENING_STEP	0\n')
			self.fichier.write('MIN_SURFAREA	0\nMAX_TRIALS	8\nHEAD_TOLERANCE	0.0015\nSYS_FLOW_TOL	5\nLAT_FLOW_TOL	5\n')
			self.fichier.write('\n[RAINGAGES]\n;;Gage	Format	Interval	SCF	Source\n;;---- 	------	---------	-----------\nPluvio	INTENSITY	0:05	1.0	FILE "I:\DOMEAU\SPDE\Planification & Coordination\Projets\SWMM\Pluies\Historique\\23_04_1988\P1988-10.dat" CHE01	MM\n')
			
			
			
				
			####[SUBCATCHMENT]
			###nom de la couche sous bassin versant
			Subcatchment=parameters[3].valueAsText
			desc=arcpy.Describe(Subcatchment)
			self.fichier.write('\n[SUBCATCHMENT]\n')
			self.fichier.write(';;['+str(Subcatchment)+']\n')
			self.fichier.write(';;Subcatchment	Rain_Gage	Outlet	Area	%Imperv	Width	%Slope	CurbLen	Snow_Pack\n')

			#selectionne 
			arcpy.SelectLayerByLocation_management(Subcatchment, "WITHIN", polygSelect, "", "NEW_SELECTION") 
			
			###reccupérer le nom des champs de la couche sous bassin versant:
			#choix du champ taux_imperm
			contenu_analyse=parameters[2].valueAsText
			if contenu_analyse.encode('utf-8')=='TAUX_IMPERM_ACTUEL':
				taux_imperm='TAUX_IMPERM_ACTUEL'
			elif contenu_analyse.encode('utf-8')=='TAUX_IMPERM_SATURATION':
				taux_imperm='TAUX_IMPERM_SATURATION'
			else:
				taux_imperm='TAUX_IMPERM_ACTUEL'
				
			arcpy.AddMessage('\nles attributs de '+str(Subcatchment)+' utilisés pour [SUBCATCHMENT] sont: ')
			self.fichierLog.write('\nles attributs de '+str(Subcatchment)+' utilisés pour [SUBCATCHMENT] sont: \n')
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;NO_COLLECTEUR;SHAPE@AREA;'+str(taux_imperm)+';PENTE_MOYENNE;COMMUNE'#SHAPE_Area#SHAPE.AREA
			attr=attributs_choisis.split(';')#créé une liste
			for i in attr:
				arcpy.AddMessage(i)
				self.fichierLog.write(str(i)+'\n')
			
			#écrire le nom des champs de la couche sous bassin versant
			self.fichier.write(';;')
			for i in range (0,len(attr)):
				self.fichier.write(attr[i]+'	')
			self.fichier.write('\n')
			
			#ligne de tirets
			self.fichier.write(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				self.fichier.write(nbtriet+' ')
			self.fichier.write('\n')
			
			
			###remplacement des canalisations par chambre amont
			#liste le NO_COLLECTEUR 
			listNO_COLL=[]
			dict_coll_chamb={}
			attributs_choisis1='CONTENU;NO_COLLECTEUR'
			attr1=attributs_choisis1.split(';')
			with arcpy.da.SearchCursor(Subcatchment, attr1) as cursor:#recherche dans sous bassin versant
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':#ne prend le type de reseau choisi
							if isinstance(row[1], basestring) is True:#1
								no_coll=str(row[1].encode('utf-8'))
							else:
								no_coll=str(row[1])
							listNO_COLL.append(no_coll)
			#arcpy.AddMessage('list NO_COLL bv=\n'+str(listNO_COLL))
			
			
			#reccupère les chambres amonts correspondantes aux collecteurs listés
			Conduits=parameters[8].valueAsText
			
			#selectionne 
			arcpy.SelectLayerByLocation_management(Conduits, "WITHIN", polygSelect, "", "NEW_SELECTION")
			
			attributs_choisis2='CONTENU;ID_OBJET_UNIQUE;NO_OBJET_AMONT'
			attr2=attributs_choisis2.split(';')
			with arcpy.da.SearchCursor(Conduits, attr2) as cursor:#cherche dans la table collecteur
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							if isinstance(row[1], basestring) is True:
								id_coll=str(row[1].encode('utf-8'))
							else:
								id_coll=str(row[1])
							if id_coll in listNO_COLL:#si identifiant du collecteur est dans la liste des exultoire du bv, reccupère l'identifiant de l'objet amont.
								if isinstance(row[2], basestring) is True:#1
									ch_AMONT=str(row[2].encode('utf-8'))
								else:
									ch_AMONT=str(row[2])
								editdict={id_coll:ch_AMONT}
								dict_coll_chamb.update(editdict)
			
			#arcpy.AddMessage('list coll chambre (coll) =\n'+str(dict_coll_chamb))
			List_idBV=[]
			###exporter les entités de la couche sous bassin versant
			with arcpy.da.SearchCursor(Subcatchment, attr) as cursor:
				for row in cursor:
					if row[1]!=None:
						#CONTENU
						if row[0] !=None:
							if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
								#Description
								self.fichier.write(';'+str(row[0].encode('utf-8'))+'/')
								if row[6]!=None:
									if isinstance(row[6], basestring) is True:#7
										self.fichier.write(str(row[6].encode('utf-8'))+'/')
									else:
										self.fichier.write(str(row[6])+'/')
								else:
									self.fichier.write('pas_de_COMMUNE')
									
								self.fichier.write('\n')
								#ID_OBJET_UNIQUE
								if isinstance(row[1], basestring) is True:
									idBV=str(row[1].encode('utf-8'))
								else:
									idBV=str(row[1])
								self.fichier.write(idBV+'	')
								List_idBV.append(idBV)
								self.fichier.write('Pluvio	')#1
								#NO_COLLECTEUR
								if row[2]!=None:
									if isinstance(row[2], basestring) is True:#7
										coll=str(row[2].encode('utf-8'))
									else:
										coll=str(row[2])
									
									#arcpy.AddMessage(str(coll))
									try:
										chambre=dict_coll_chamb[coll]
									except:
										chambre='None'
										listBVsansObjAmont.append(idBV)
										
									if chambre=='' or chambre==' ' or chambre=='-'or chambre==None or chambre=='<Nul>':
										chambre='None'
								else:
									chambre='None'
								self.fichier.write(str(chambre)+'	')#edite l' objet amont a la place du collecteur exultoire du bv
								
								#SHAPE.AREA à /10 000
								if row[3] is None:
									self.fichier.write('SHAPE.AREAisNULL	')
								else:
									shape_area=str(float(row[3])/10000)#convertion m2 -> ha 
									self.fichier.write(shape_area+'	')
								
								#taux_imperm
								if row[4]!=None:
									if isinstance(row[4], basestring) is True:#7
										row_encodee=str(row[4].encode('utf-8'))
									else:
										row_encodee=str(row[4])
									self.fichier.write(row_encodee+'	')
								else:
									self.fichier.write('50	')
									
								if row[3]!=None:
									Lbv=math.sqrt(float(row[3]))
								else:
									Lbv=None
								self.fichier.write(str(Lbv)+'	')#6
								#PENTE_MOYENNE
								if isinstance(row[5], basestring) is True:#7
									row_encodee=str(row[5].encode('utf-8'))
								else:
									row_encodee=str(row[5])
								self.fichier.write(row_encodee+'	')
								self.fichier.write('0')#8
								self.fichier.write('\n')
			if len(listBVsansObjAmont)>0:
				arcpy.AddMessage('\n'+str(len(listBVsansObjAmont))+' bassins versants n\'ont pas de collecteurs attribués ou ces collecteurs ne sont pas selectionnés pour l\'analyse ou ces collecteurs n\'ont pas d\'objet amont:\n'+str(listBVsansObjAmont))
			
			####[SUBAREAS]
			self.fichier.write('\n[SUBAREAS]\n')
			self.fichier.write(';;Subcatchment	N-Imperv	N-Perv	S-imperv	S-Perv	PctZero	RouteTo	PctRouted\n')
			self.fichier.write(';;------------	--------	------	--------	------	-------	-------	---------\n')
			##id bassin versant
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE'
			attr=attributs_choisis.split(';')
			with arcpy.da.SearchCursor(Subcatchment, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							if isinstance(row[1], basestring) is True:#1
								row_encodee=str(row[1].encode('utf-8'))
							else:
								row_encodee=str(row[1])
							self.fichier.write(row_encodee+'	')
							
							self.fichier.write('0.012	0.1	1	5	0	OUTLET')
							self.fichier.write('\n')
			
			####[INFILTRATION]
			self.fichier.write('\n[INFILTRATION]\n')
			self.fichier.write(';;Subcatchment	MaxRate	MinRate	Decay	DryTime	MaxInfil\n')
			self.fichier.write(';;------------	-------	-------	-----	-------	--------\n')
			##id bassin versant
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE'
			attr=attributs_choisis.split(';')
			with arcpy.da.SearchCursor(Subcatchment, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							if isinstance(row[1], basestring) is True:#1
								row_encodee=str(row[1].encode('utf-8'))
							else:
								row_encodee=str(row[1])
							self.fichier.write(row_encodee+'	')
							self.fichier.write('75	3	5	4')
							self.fichier.write('\n')
			
			
			####[JUNCTIONS]
			self.fichier.write('\n[JUNCTIONS]\n')
			###nom de la couche sous bassin versant
			Junctions=parameters[4].valueAsText
			desc=arcpy.Describe(Junctions)
			self.fichier.write(';;['+str(Junctions)+']\n')
			self.fichier.write(';;Junction	Invert	Dmax	Dinit	Dsurch	Aponded\n')
			#selectionne 
			arcpy.SelectLayerByLocation_management(Junctions, "WITHIN", polygSelect, "", "NEW_SELECTION") 
			#champs
			arcpy.AddMessage('\nles attributs de '+str(Junctions)+' utilisés pour [JUNCTIONS] sont: ')
			self.fichierLog.write('\nles attributs de '+str(Junctions)+' utilisés pour [JUNCTIONS] sont: \n')
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;ALTITUDE_FIL_EAU_M;PROFONDEUR;ALTITUDE_COUVERCLE;RESEAU;NOM_OBJET_USUEL;COMMUNE'
			attr=attributs_choisis.split(';')#créé une liste
			for i in attr:
				arcpy.AddMessage(i)
				self.fichierLog.write(str(i)+'\n')
			#écrire le nom des champs de la couche sous bassin versant
					
			#ligne de tirets
			self.fichier.write(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				self.fichier.write(nbtriet+' ')
			self.fichier.write('\n')
			dictChambre={}
			###exporter les entités de la couche sous bassin versant
			with arcpy.da.SearchCursor(Junctions, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						#CONTENU
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							#RESEAU
							select_branchement='non'
							try:
								if row[5].encode('utf-8')!='Branchement':
									select_branchement='ok'
							except:
								if row[5]!='Branchement':
									select_branchement='ok'
									
							if select_branchement=='ok':#None ou !='Branchement'
								#Description
								self.fichier.write(';'+str(row[0].encode('utf-8'))+'/')
								if row[6]!=None:
									if isinstance(row[6], basestring) is True:#7
										self.fichier.write(str(row[6].encode('utf-8'))+'/')
									else:
										self.fichier.write(str(row[6])+'/')
								else:
									self.fichier.write('pas_de_NOM_OBJET_USUEL/')
									
								if row[7]!=None:
									if isinstance(row[7], basestring) is True:#7
										self.fichier.write(str(row[7].encode('utf-8'))+'/')
									else:
										self.fichier.write(str(row[7])+'/')
								else:
									self.fichier.write('pas_de_COMMUNE')
								self.fichier.write('\n')
								#ID_OBJET_UNIQUE
								if isinstance(row[1], basestring) is True:
									idChambre=str(row[1].encode('utf-8'))
								else:
									idChambre=str(row[1])
								self.fichier.write(idChambre+'	')
								#ALTITUDE_FIL_EAU_M
								if row[2]==None:
									self.fichier.write('0	')
									dictChambre[idChambre]=0
									listRegardsansAltitude.append(idChambre)
								else:
									if isinstance(row[2], basestring) is True:
										row_encodee=float(row[2])
									else:
										row_encodee=row[2]
									self.fichier.write(str(row_encodee)+'	')
									dictChambre[idChambre]=row_encodee
								#PROFONDEUR
								if row[3]==None:#Si le champ PROFONDEUR n'est pas rempli, la valeure correspondra à la différence entre ALTITUDE_COUVERCLE et ALTITUDE_FIL_EAU_M
									if row[2]!=None and row[4]!=None:	#row[4]:ALTITUDE_COUVERCLE
										prof=float(row[4])-float(row[2])
									else:
										prof=10
									self.fichier.write(str(prof)+'	')
								else:
									if isinstance(row[3], basestring) is True:
										row_encodee=str(row[i].encode('utf-8'))
									else:
										row_encodee=str(row[3])
									self.fichier.write(row_encodee+'	')
								self.fichier.write('0	0	0\n')
			
			
			####[OUTFALLS]
			self.fichier.write('\n[OUTFALLS]\n')
			###nom de la couche rejets
			Outfalls=parameters[5].valueAsText
			desc=arcpy.Describe(Outfalls)
			self.fichier.write(';;['+str(Outfalls)+']\n')
			self.fichier.write(';;Outfall	Invert	Type	Stage_Data	Gated\n')
			#selectionne 
			arcpy.SelectLayerByLocation_management(Outfalls, "WITHIN", polygSelect, "", "NEW_SELECTION") 
			#champs
			arcpy.AddMessage('\nles attributs de '+str(Outfalls)+' utilisés pour [OUTFALLS] sont: ')
			self.fichierLog.write('\nles attributs de '+str(Outfalls)+' utilisés pour [OUTFALLS] sont: \n')
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;ALTITUDE_RADIER_M'
			attr=attributs_choisis.split(';')#créé une liste des attributs
			for i in attr:
				arcpy.AddMessage(i)
				self.fichierLog.write(str(i)+'\n')
			
			#ligne de tirets
			self.fichier.write(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				self.fichier.write(nbtriet+' ')
			self.fichier.write('\n')
			
			###exporter les entités de la couche
			countOutfall=0
			with arcpy.da.SearchCursor(Outfalls, attr) as cursor:
				for row in cursor:
					countOutfall +=1
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							for i in range (1,len(row)):
							
								if isinstance(row[i], basestring) is True:
									row_encodee=str(row[i].encode('utf-8'))
									
								else:
									row_encodee=str(row[i])
								self.fichier.write(row_encodee+'	')
							self.fichier.write('FREE	 	NO')
							self.fichier.write('\n')
			
			self.fichierLog.write('il y a '+str(countOutfall)+' points de rejet [OUTFALL] dans la zone sélectionnée\n')
			arcpy.AddMessage('il y a '+str(countOutfall)+' points de rejet [OUTFALL] dans la zone sélectionnée\n')
			
			####[DIVIDERS]
			dividers_txt=[]
			dividers_txt.append('\n[DIVIDERS]\n')
			
			###nom de la couche deversoir
			Deversoir=parameters[6].valueAsText
			desc=arcpy.Describe(Deversoir)
			dividers_txt.append('\n;;['+str(Deversoir)+']\n')
			dividers_txt.append(';;Divider	Invert	Diverted Link	Type	Parameters\n')
			
			#selectionne 
			arcpy.SelectLayerByLocation_management(Deversoir, "WITHIN", polygSelect, "", "NEW_SELECTION") 
			#champs
			arcpy.AddMessage('\nles attributs de '+str(Deversoir)+' utilisés pour [DIVIDERS] sont: ')
			self.fichierLog.write('\nles attributs de '+str(Deversoir)+' utilisés pour [DIVIDERS] sont: \n')
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;ALTITUDE_ENTREE_EM_M'
			attr=attributs_choisis.split(';')
			for i in attr:
				arcpy.AddMessage(i)
				self.fichierLog.write(str(i)+'\n')
			
			
			listval='*	CUTOFF	0 0 0 0 0'
			
			#ligne de tirets
			dividers_txt.append(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				dividers_txt.append(nbtriet+' ')
			dividers_txt.append('\n')
			
			###exporter les entités de la couche sous bassin versant
			count=0
			with arcpy.da.SearchCursor(Deversoir, attr) as cursor:
				for row in cursor:
					count+=1
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							for i in range (1,len(row)):
							
								if isinstance(row[i], basestring) is True:
									row_encodee=str(row[i].encode('utf-8'))
									
								else:
									row_encodee=str(row[i])
								dividers_txt.append(row_encodee+'	')
							dividers_txt.append('*	CUTOFF	0 0 0 0 0')
							dividers_txt.append('\n')

			if count>0:
				dv=''.join(dividers_txt)
				self.fichier.write(dv)
			self.fichierLog.write('\nil y a '+str(count)+' deversoirs dans la zone selectionnée\n')
			arcpy.AddMessage('\nil y a '+str(count)+' deversoirs dans la zone selectionnée\n')
				
			####[STORAGE]
			storage_txt=[]
			storage_txt.append('\n[STORAGE]\n')
			###nom de la couche Storage
			Storage=parameters[7].valueAsText
			desc=arcpy.Describe(Storage)
			storage_txt.append('\n;;['+str(Storage)+']\n')
			storage_txt.append(';;Storage_Node	Invert	Dmax	Dinit	Curve	Name/Params	Aponded	Fevap	SeepRate\n')
			#selectionne 
			arcpy.SelectLayerByLocation_management(Storage, "WITHIN", polygSelect, "", "NEW_SELECTION") 
			#champs
			arcpy.AddMessage('\nles attributs de '+str(Storage)+' utilisé pour [STORAGE] sont: ')
			self.fichierLog.write('\nles attributs de '+str(Storage)+' utilisé pour [STORAGE] sont: \n')
			
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE'
			attr=attributs_choisis.split(';')#créé une liste
			for i in attr:
				arcpy.AddMessage(i)
				self.fichierLog.write(str(i)+'\n')
			
			
			
			#ligne de tirets
			storage_txt.append(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				storage_txt.append(nbtriet+' ')
			storage_txt.append('\n')
			
			###exporter les entités de la couche sous bassin versant
			count2=0
			with arcpy.da.SearchCursor(Storage, attr) as cursor:
				for row in cursor:
					count2 +=1
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							for i in range (1,len(row)):
							
								if isinstance(row[i], basestring) is True:
									row_encodee=str(row[i].encode('utf-8'))
									
								else:
									row_encodee=str(row[i])
								storage_txt.append(row_encodee+'	')
							storage_txt.append('0	0	0	FUNCTIONNAL	1000 0 0	0	0	0')
							storage_txt.append('\n')
			
			if count2<0:
				sv=''.join(storage_txt)
				self.fichier.write(sv)
			self.fichierLog.write('\nil y a '+str(count2)+' stockage eaux dans la zone selectionnée\n')
			arcpy.AddMessage('\nil y a '+str(count2)+' stockage eaux dans la zone selectionnée\n')
			
			####[CONDUITS]
			self.fichier.write('\n[CONDUITS]\n')
			###nom de la couche Conduits
			#Conduits=parameters[8].valueAsText#ligne302
			desc=arcpy.Describe(Conduits)
			
			self.fichier.write('\n;;['+str(Conduits)+']\n')
			self.fichier.write(';;Conduit	From Node	To_Node	Length	Roughness	InOffset	OutOffset	InitFlow	MaxFlow\n')
			#selectionne 
			arcpy.SelectLayerByLocation_management(Conduits, "WITHIN", polygSelect, "", "NEW_SELECTION") 
			#champs
			arcpy.AddMessage('\nles attributs de '+str(Conduits)+' utilisé pour [CONDUITS] sont: ')
			self.fichierLog.write('\nles attributs de '+str(Conduits)+' utilisé pour [CONDUITS] sont: \n')
			attributs_choisis='CONTENU;RESEAU;ID_OBJET_UNIQUE;NO_OBJET_AMONT;NO_OBJET_AVAL;SHAPE@LENGTH;MATERIAU;ALTITUDE_AMONT_M;ALTITUDE_AVAL_M'#SHAPE_Length#SHAPE.LEN
			attr=attributs_choisis.split(';')#créé une listedes attributs
			for i in attr:
				arcpy.AddMessage(i)
				self.fichierLog.write(str(i)+'\n')
			
			listval='0	0'
			#matériaux
			dictMat={'Acier':0.0125,'Acier inoxydable':0.0125,'Amiante-ciment':0.0167,'Autre':0.013,'Béton':0.0167,'Béton armé':0.0167,'Chlorure de polyvinyl PVC':0.0125,'Fibre de verre':0.0125,'Fonte ductile':0.02,'Fonte grise':0.02,'Grès':0.02,'Inconnu':0.0125,'Polyester non saturé':0.0125,'Polypropylène':0.0125,'Polyéthylène dur PE':0.0125,'Résine époxy':0.013,'Terre cuite':0.02}
			#ligne de tirets
			self.fichier.write(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				self.fichier.write(nbtriet+' ')
			self.fichier.write('\n')
			
			###exporter les entités de la couche collecteur
			IDcoll=[]
			select_branchement='non'
			with arcpy.da.SearchCursor(Conduits, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						#CONTENU
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							#RESEAU
							select_branchement='non'
							try:
								if row[1].encode('utf-8')!='Branchement':
									select_branchement='ok'
							except:
								if row[1]!='Branchement':
									select_branchement='ok'
									
							if select_branchement=='ok':#None ou !='Branchement'
								##Description
								self.fichier.write(';'+str(row[0].encode('utf-8'))+'\n')
								#ID_OBJET_UNIQUE
								if row[2]!=None:
									if isinstance(row[2], basestring) is True:
										idConduit=str(row[2].encode('utf-8'))
										
										
									else:
										idConduit=str(row[2])
									self.fichier.write(idConduit+'	')
									IDcoll.append(idConduit)
									#Log si attribut 'RESEAU'==None
									if row[1]==None:
										autres_erreurs +='Le collecteur (conduit) '+str(idConduit)+' à la valeur None pour l\'attribut RESEAU\n'
									#NO_OBJET_AMONT
									if row[3] is None:
										listConduitsansObjAmont.append(idConduit)
										row_encodee='0'
									else:
										if isinstance(row[3], basestring) is True:
											row_encodee=str(row[3].encode('utf-8'))
										else:
											row_encodee=str(row[3])
										self.fichier.write(row_encodee+'	')
									#NO_OBJET_AVAL
									if row[4] is None:
										listConduitsansObjAval.append(idConduit)
										row_encodee='0'
									else:
										if isinstance(row[4], basestring) is True:
											row_encodee=str(row[4].encode('utf-8'))
										else:
											row_encodee=str(row[4])
										self.fichier.write(row_encodee+'	')
									#SHAPE.LEN
									if isinstance(row[5], basestring) is True:
										row_encodee=str(row[5].encode('utf-8'))
									else:
										row_encodee=str(row[5])
									self.fichier.write(row_encodee+'	')
									#arcpy.AddMessage(str(row[6].encode('utf-8'))+': '+str(dictMat[str(row[6].encode('utf-8'))]))
									#MATERIAU
									
									try:
										self.fichier.write(str(dictMat[str(row[6].encode('utf-8'))]))
									except:
										self.fichier.write('0.0125')
									self.fichier.write('	')
									
									if isinstance(row[3], basestring) is True:
										idAmont=str(row[3].encode('utf-8'))
										
									else:
										idAmont=str(row[3])
									
									if isinstance(row[4], basestring) is True:
										idAval=str(row[4].encode('utf-8'))
										
									else:
										idAval=str(row[4])
									#ALTITUDE_AMONT_M
									altAmont=row[7]
									#ALTITUDE_AVAL_M
									altAval=row[8]
										
									try:
										difAltAmont=altAmont-dictChambre[idAmont]
									except:
										difAltAmont=None
									try:
										difAltAval=altAval-dictChambre[idAval]
									except:
										difAltAval=None
									
									
									if difAltAmont==None:
										self.fichier.write('0	')
									elif difAltAmont<0.05:
										self.fichier.write('0	')
									else:
										self.fichier.write(str(difAltAmont)+'	')
										
									if difAltAval==None:
										self.fichier.write('0	')
									elif difAltAval<0.05:
										self.fichier.write('0	')
									else:
										self.fichier.write(str(difAltAval)+'	')
									# for i in range (7,len(row)):
									
										# if isinstance(row[i], basestring) is True:
											# row_encodee=str(row[i].encode('utf-8'))
											
										# else:
											# row_encodee=str(row[i])
										# self.fichier.write(row_encodee+'	')
									self.fichier.write('0	0')
									self.fichier.write('\n')
							
							
			####[XSECTIONS]
			self.fichier.write('\n[XSECTIONS]\n')
			Xsections=parameters[8].valueAsText#même parametre que conduit car même classe d'entité
			desc=arcpy.Describe(Xsections)
			self.fichier.write('\n;;['+str(Xsections)+']\n')
			self.fichier.write(';;Link	Shape	Geom1	Geom2	Geom3	Geom4	Barrels\n')
			#selectionne 
			arcpy.SelectLayerByLocation_management(Xsections, "WITHIN", polygSelect, "", "NEW_SELECTION") 
			#champs
			arcpy.AddMessage('\nles attributs de '+str(Xsections)+' utilisé pour [XSECTIONS] sont: ')
			self.fichierLog.write('\nles attributs de '+str(Xsections)+' utilisé pour [XSECTIONS] sont:\n')
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;PROFIL_COLLECTEUR;DIAMETRE_HAUTEUR;LARGEUR;RESEAU'
			attr=attributs_choisis.split(';')#créé une liste
			for i in attr:
				arcpy.AddMessage(i)
				self.fichierLog.write(str(i)+'\n')
			
			#ligne de tirets
			self.fichier.write(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				self.fichier.write(nbtriet+' ')
			self.fichier.write('\n')
			
			select_branchement='non'
			largeur=False
			listval='0	0	0	1'
			dictShape={'Autre':'CIRCULAR','Circulaire':'CIRCULAR','En U':'CIRCULAR','En voûte':'RECT_CLOSED','En voûte avec deux trottoirs':'CIRCULAR','En voûte avec un trottoir':'CIRCULAR','Inconnu':'CIRCULAR','Ovoïde':'EGG','Profil spécial':'CIRCULAR','Profilé de protection double':'CIRCULAR','Profilé de protection simple':'CIRCULAR','Rectangulaire':'RECT_CLOSED'}
			#dictGeom2={'Autre':,'Circulaire':,'En U':,'En voûte':,'En voûte avec deux trottoirs':,'En voûte avec un trottoir':,'Inconnu':,'Ovoïde':,'Profil spécial':,'Profilé de protection double':,'Profilé de protection simple':,'Rectangulaire':}}
			with arcpy.da.SearchCursor(Xsections, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						#CONTENU
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							select_branchement='non'
							try:
								if row[5].encode('utf-8')!='Branchement':
									select_branchement='ok'
							except:
								if row[5]!='Branchement':
									select_branchement='ok'
									
							if select_branchement=='ok':#None ou !='Branchement'
								#ID_OBJET_UNIQUE
								if isinstance(row[1], basestring) is True:
									idConduit2=str(row[1].encode('utf-8'))
								else:
									idConduit2=str(row[1])
								self.fichier.write(idConduit2+'	')
								#PROFIL_COLLECTEUR
								if row[2]==None:
									self.fichier.write('CIRCULAR	')
								else:
									if isinstance(row[2], basestring) is True:
										row_encodee=row[2].encode('utf-8')
									else:
										row_encodee=row[2]
									#arcpy.AddMessage(str(row_encodee)+': '+dictShape[str(row_encodee)])
									if row_encodee in dictShape:
										self.fichier.write(dictShape[str(row_encodee)]+'	')
									else:
										autres_erreurs+='le collecteur '+str(idConduit2)+' à la valeur \''+str(row_encodee)+'\' pour l\'attribut PROFIL_COLLECTEUR\n'
										arcpy.AddMessage('le collecteur '+str(idConduit2)+' à la valeur \''+str(row_encodee)+'\' pour l\'attribut PROFIL_COLLECTEUR\nCela ne correspond pas aux valeurs prévues\n')
										self.fichier.write('CIRCULAR	')
									if str(row_encodee)=='En voûte' or str(row_encodee)=='Rectangulaire':
										largeur=True
									else:
										largeur=False
								#DIAMETRE_HAUTEUR
								if row[3] is None:
									self.fichier.write('0.5	')
								else:
									diametreH=str(float(row[3])/1000)#convertion mm -> m 
									self.fichier.write(diametreH+'	')
								#LARGEUR
								if row[4] is None:
									self.fichier.write('0	')
								else:
									if largeur is True:
										diametreLargeur=str(float(row[4])/1000)
										self.fichier.write(diametreLargeur+'	')
									else:
										self.fichier.write('0	')
									
								self.fichier.write('0	0	1\n')
			
			
			####[LOSSES]
			self.fichier.write('\n[LOSSES]\n')
			self.fichier.write(';;Link	Kin	Kout	Kavg	Flap Gate	SeepRate\n;;----	--------	----	---------	--------')
			
			####[REPORT]
			self.fichier.write('\n[REPORT]\n')
			self.fichier.write('INPUT	NO\nCONTROLS	NO\nSUBCATCHMENTS	ALL\nNODES	ALL\nLINKS	ALL\n')
			
			
			####[TAGS]
			self.fichier.write('\n[TAGS]\n')
			
			####[MAPS]
			self.fichier.write('\n[MAPS]\n')
			#polygSelect=parameters[0].valueAsText
			desc=arcpy.Describe(polygSelect)
			arcpy.AddMessage("\nDIMENSIONS	{0}	{1}	{2}	{3}\nUnits	meters\n".format(desc.extent.XMin, desc.extent.YMin, desc.extent.XMax, desc.extent.YMax))
			self.fichier.write('\nDIMENSIONS	{0}	{1}	{2}	{3}\nUnits	meters\n'.format(desc.extent.XMin, desc.extent.YMin, desc.extent.XMax, desc.extent.YMax))
			
			####[COORDINATES]
			self.fichier.write('\n[COORDINATES]\n')
			self.fichier.write(';;Node	X-Coord	Y-Coord\n')
			#coordonnées regard_chambre
			coordJunction=parameters[4].valueAsText
			desc=arcpy.Describe(coordJunction)
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;SHAPE@XY'#COORD_X;COORD_Y'
			attr=attributs_choisis.split(';')
			
			#ligne de tirets
			self.fichier.write(';;')
			for i in range (0,len(attr)):
				nbtriet='---'
				for j in range (0,len(attr[i])):
					nbtriet=str(nbtriet)+'-'
				self.fichier.write(nbtriet+' ')
			self.fichier.write('\n')
			
			with arcpy.da.SearchCursor(coordJunction, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							self.fichier.write("{0}	{1}	{2}".format(row[1], row[2][0],row[2][1]))
							self.fichier.write('\n')
			
			#coordonnées pt_rejet
			coordRejet=parameters[5].valueAsText
			desc=arcpy.Describe(coordRejet)
			shapefieldname = desc.ShapeFieldName
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;SHAPE@XY'
			attr=attributs_choisis.split(';')
			
			with arcpy.da.SearchCursor(coordRejet, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							self.fichier.write("{0}	{1}	{2}".format(row[1], row[2][0],row[2][1]))
							self.fichier.write('\n')
			
			#coordonnées Deversoir
			coordDeversoir=parameters[6].valueAsText
			desc=arcpy.Describe(coordDeversoir)
			shapefieldname = desc.ShapeFieldName
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;SHAPE@XY'
			attr=attributs_choisis.split(';')
			
			with arcpy.da.SearchCursor(coordDeversoir, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							self.fichier.write("{0}	{1}	{2}".format(row[1], row[2][0],row[2][1]))
							self.fichier.write('\n')
			
			#coordonnées Stockage
			coordStockage=parameters[7].valueAsText
			desc=arcpy.Describe(coordStockage)
			shapefieldname = desc.ShapeFieldName
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE;SHAPE@XY'
			attr=attributs_choisis.split(';')
			
			with arcpy.da.SearchCursor(coordStockage, attr) as cursor:
				for row in cursor:
					if row[0]!=None:
						if row[0].encode('utf-8')==type_reseau or row[0].encode('utf-8')=='Eaux mélangées':
							self.fichier.write("{0}	{1}	{2}".format(row[1], row[2][0],row[2][1]))
							self.fichier.write('\n')
			
			
			####[VERTICES]
			self.fichier.write('\n[VERTICES]\n')
			self.fichier.write(';;Link	X-Coord	Y-Coord\n')
			#coordonnées collecteurs
			coordCollecteurs=parameters[8].valueAsText
			desc=arcpy.Describe(coordCollecteurs)
			shapefieldname = desc.ShapeFieldName
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE'
			attr=attributs_choisis.split(';')
			#ligne de tirets
			self.fichier.write(';;----	-------	-------\n')
			
			
			field='ID_OBJET_UNIQUE'
			rows=arcpy.SearchCursor(coordCollecteurs)
			
			for row in rows:
				if row.getValue(field)!=None:
					if row.getValue(field)in IDcoll:
						
						feat = row.getValue(shapefieldname)
						pnt = feat.getPart()
						partnum = 0
						# Step through each part of the feature
						#
						for part in feat:
							# Step through each vertex in the feature
							#
							for pnt in feat.getPart(partnum):
								if pnt:
									# Pnt.X et pnt.Y sont les coordonnées des points du polygone
									try:
										self.fichier.write(str(row.getValue(field))+'	'+str(pnt.X)+'	'+str(pnt.Y))
										self.fichier.write('\n')
										
									except:
										arcpy.AddMessage('partnum: '+str(partnum))
								else:
									# If pnt is None, this represents an interior ring
									#
									self.fichier.write('Interior Ring:\n')
								
							partnum += 1
						
			
			
			
			####[Polygons]
			self.fichier.write('\n[Polygons]\n')
			self.fichier.write(';;Subcatchment	X-Coord	Y-Coord\n')
			#coordonnées sous bassin versant
			coordBV=parameters[3].valueAsText
			desc=arcpy.Describe(coordBV)
			shapefieldname = desc.ShapeFieldName
			attributs_choisis='CONTENU;ID_OBJET_UNIQUE'
			attr=attributs_choisis.split(';')
			#ligne de tirets
			self.fichier.write(';;-----------	-------	-------\n')
			
						
			field='ID_OBJET_UNIQUE'
			rows=arcpy.SearchCursor(coordBV)
			for row in rows:
				if row.getValue(field)!=None:
					if row.getValue(field) in List_idBV:#if row.getValue(field).encode('utf-8')==type_reseau or row.getValue(field).encode('utf-8')=='Eaux mélangées':
						feat = row.getValue(shapefieldname)
						pnt = feat.getPart()
						partnum = 0
						# Step through each part of the feature
						#
						for part in feat:
							# Step through each vertex in the feature
							#
							for pnt in feat.getPart(partnum):
								if pnt:
									# Pnt.X et pnt.Y sont les coordonnées des points du polygone
									try:
										self.fichier.write(str(row.getValue(field))+'	'+str(pnt.X)+'	'+str(pnt.Y))#self.fichier.write(str(idBV[partnum])+'	'+str(pnt.X)+'	'+str(pnt.Y))
										self.fichier.write('\n')
									except:
										arcpy.AddMessage('partnum: '+str(partnum))
								else:
									# If pnt is None, this represents an interior ring
									#
									self.fichier.write('Interior Ring:\n')
									
							partnum += 1
							

			####[SYMBOLS]
			self.fichier.write('\n[SYMBOLS]\n')
			self.fichier.write(';;Gage	X-Coord	Y-Coord\n;;-------------- ------------------ ------------------\n')
			desc=arcpy.Describe(polygSelect)
			X_Coord=float(desc.extent.XMin)+(float(desc.extent.XMax)-float(desc.extent.XMin))/10
			Y_Coord=float(desc.extent.YMax)-(float(desc.extent.YMax)-float(desc.extent.YMin))/10
			self.fichier.write('Pluvio	'+str(X_Coord)+'	'+str(Y_Coord)+'\n')
			
			
			
			self.fichier.close()
			
			### liste les objets avec des données manquantes
			self.fichierLog.write('\n\n\n----------BILAN DES ERREURS----------\n')
			if countOutfall==0:
				self.fichierLog.write('\nIl n\'y a pas de points de rejet [OUTFALL] dans la zone sélectionnée\n')
				
			if len(listBVsansObjAmont)>0:
				self.fichierLog.write('\nATTENTION '+str(len(listBVsansObjAmont))+' bassins versants n\'ont pas de collecteurs attribués ou ces collecteurs ne sont pas selectionnés pour l\'analyse ou ces collecteurs n\'ont pas d\'objet amont:\n')
				for i in listBVsansObjAmont:
					self.fichierLog.write(str(i)+'\n')
			
			if len(listRegardsansAltitude)>0:
				self.fichierLog.write('\nATTENTION '+str(len(listRegardsansAltitude))+' regards n\'ont pas d\'altitude au fil de l\'eau:\n')
				for i in listRegardsansAltitude:
					self.fichierLog.write(str(i)+'\n')
			
			if len(listConduitsansObjAmont)>0:
				self.fichierLog.write('\nATTENTION '+str(len(listConduitsansObjAmont))+' conduits n\'ont pas d\'objets amont:\n')
				for i in listConduitsansObjAmont:
					self.fichierLog.write(str(i)+'\n')
			
			if len(listConduitsansObjAval)>0:
				self.fichierLog.write('\nATTENTION '+str(len(listConduitsansObjAval))+' conduits n\'ont pas d\'objets aval:\n')
				for i in listConduitsansObjAval:
					self.fichierLog.write(str(i)+'\n')
			
			self.fichierLog.write(autres_erreurs)
			d=datetime.datetime.now()
			self.fichierLog.write(str(d.day)+'/'+str(d.month)+'/'+str(d.year)+' '+str(d.hour)+'h'+str(d.minute)+'\nl\'export s\'est exécuté avec succès')
			self.fichierLog.close()
			return
		
		except Exception as exceptions:
			
			d=datetime.datetime.now()
			arcpy.AddMessage(str(d.day)+'/'+str(d.month)+'/'+str(d.year)+' '+str(d.hour)+'h'+str(d.minute)+'\nl\'export s\'est terminée sur une erreur')
			arcpy.AddMessage(exceptions)
			self.fichierLog.write(str(d.day)+'/'+str(d.month)+'/'+str(d.year)+' '+str(d.hour)+'h'+str(d.minute)+'\nl\'export s\'est terminée sur une erreur')
			self.fichierLog.write(str(exceptions))
			self.fichierLog.close()